<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/session.php';
require_once __DIR__ . '/includes/wallet.php';
require_once __DIR__ . '/includes/db.php';
require_login();
$u = current_user();
$err=''; $ok='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $amount = (float)($_POST['amount'] ?? 0);
  if($amount <= 0){
    $err = 'Invalid amount';
  } else {
    try{
      // Manual topup (demo)
      $pdo = db();
      $pdo->prepare("INSERT INTO payments(user_id,gateway,order_id,txn_id,amount,status,created_at) VALUES(?,?,?,?,?,'SUCCESS',NOW())")
          ->execute([$u['id'],'manual', 'MANUAL-'.time(), 'TXN-'.time(), $amount]);
      $pid = (int)$pdo->lastInsertId();
      wallet_credit($u['id'], $amount, 'TOPUP', 'payment', $pid);
      $ok = 'Wallet credited successfully.';
    } catch(Exception $e){
      $err = 'Error: '.$e->getMessage();
    }
  }
}

require __DIR__ . '/_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-4"></div>
  <div class="col-4">
    <div class="card">
      <h2>Recharge Wallet</h2>
      <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>
      <form method="post">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <label>Amount (₹)</label>
        <input name="amount" type="number" step="0.01" min="1" required>
        <div class="row" style="margin-top:12px">
          <button class="btn primary" type="submit">Recharge</button>
          <a class="btn" href="/dashboard.php">Back</a>
        </div>
      </form>
      <div class="small" style="margin-top:10px">This is a demo manual recharge. Payment gateway integration skeleton included in docs.</div>
    </div>
  </div>
  <div class="col-4"></div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
