<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/db.php';
require_login();
$u = current_user();
$pdo = db();
$stmt = $pdo->prepare("SELECT * FROM wallet_ledger WHERE user_id=? ORDER BY id DESC LIMIT 200");
$stmt->execute([$u['id']]);
$rows = $stmt->fetchAll();

require __DIR__ . '/_layout_top.php';
?>
<div class="card" style="margin-top:14px">
  <h2>Wallet Ledger</h2>
  <table class="table">
    <thead><tr><th>#</th><th>Type</th><th>Amount</th><th>Reason</th><th>Opening</th><th>Closing</th><th>Date</th></tr></thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= htmlspecialchars($r['type']) ?></td>
          <td>₹<?= number_format((float)$r['amount'],2) ?></td>
          <td><?= htmlspecialchars($r['reason']) ?></td>
          <td>₹<?= number_format((float)$r['opening_balance'],2) ?></td>
          <td>₹<?= number_format((float)$r['closing_balance'],2) ?></td>
          <td><?= htmlspecialchars($r['created_at']) ?></td>
        </tr>
      <?php endforeach; ?>
      <?php if(!$rows): ?><tr><td colspan="7" class="small">No ledger entries.</td></tr><?php endif; ?>
    </tbody>
  </table>
  <div class="row" style="margin-top:10px"><a class="btn" href="/dashboard.php">Back</a></div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
