<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/session.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/wallet.php';
require_login();
$u = current_user();
$pdo = db();

$code = trim($_GET['code'] ?? '');
$stmt = $pdo->prepare("SELECT * FROM services WHERE code=? AND status=1 LIMIT 1");
$stmt->execute([$code]);
$service = $stmt->fetch();
if(!$service){
  http_response_code(404);
  exit('Service not found');
}

$err=''; $ok=''; $result=null;

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $input = trim($_POST['input'] ?? '');
  if(!$input){
    $err='Please enter input.';
  } else {
    $cost = (float)$service['price'];
    try {
      // Create request first
      $pdo->prepare("INSERT INTO service_requests(user_id,service_id,input_json,status,cost,created_at) VALUES(?,?,?, 'PENDING', ?, NOW())")
          ->execute([$u['id'], $service['id'], json_encode(['input'=>$input], JSON_UNESCAPED_UNICODE), $cost]);
      $rid = (int)$pdo->lastInsertId();

      // Debit wallet atomically
      wallet_debit($u['id'], $cost, 'SERVICE_CHARGE', 'service_request', $rid);

      // Call API if configured
      $endpoint = trim($service['endpoint_url'] ?? '');
      $apiKey = trim($service['api_key'] ?? '');
      $method = strtoupper(trim($service['http_method'] ?? 'POST'));

      if($endpoint){
        $ch = curl_init();
        $payload = json_encode(['input'=>$input, 'service_code'=>$service['code']], JSON_UNESCAPED_UNICODE);
        $headers = ['Content-Type: application/json'];
        if($apiKey) $headers[] = 'Authorization: Bearer '.$apiKey;

        curl_setopt_array($ch, [
          CURLOPT_URL => $endpoint,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_TIMEOUT => 25,
          CURLOPT_HTTPHEADER => $headers,
        ]);
        if($method === 'GET'){
          // simple GET by query param
          curl_setopt($ch, CURLOPT_URL, $endpoint.'?input='.urlencode($input));
        } else {
          curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
          curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        }
        $resp = curl_exec($ch);
        $curlErr = curl_error($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if($curlErr){
          throw new Exception('API error: '.$curlErr);
        }
        $result = ['http'=>$http, 'response'=>$resp];
      } else {
        // Demo response
        $result = ['demo'=>true,'message'=>'API not configured in admin. This is a demo response.','input'=>$input];
      }

      $pdo->prepare("UPDATE service_requests SET status='SUCCESS', result_json=? WHERE id=?")
          ->execute([json_encode($result, JSON_UNESCAPED_UNICODE), $rid]);
      $ok='Success. Wallet charged.';
    } catch(Exception $e){
      $err='Failed: '.$e->getMessage();
      // Mark failed if request created
      if(!empty($rid ?? null)){
        $pdo->prepare("UPDATE service_requests SET status='FAILED', result_json=? WHERE id=?")
            ->execute([json_encode(['error'=>$err], JSON_UNESCAPED_UNICODE), $rid]);
      }
    }
  }
}

require __DIR__ . '/_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-8">
    <div class="card">
      <h2><?= htmlspecialchars($service['name']) ?></h2>
      <p>Price per hit: <b>₹<?= number_format((float)$service['price'],2) ?></b></p>

      <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>

      <form method="post">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <label>Input</label>
        <input name="input" placeholder="Enter value..." required>
        <div class="row" style="margin-top:12px">
          <button class="btn primary" type="submit">Submit</button>
          <a class="btn" href="/dashboard.php">Back</a>
        </div>
      </form>

      <?php if($result): ?>
        <hr>
        <h2>Result</h2>
        <pre style="white-space:pre-wrap;background:rgba(0,0,0,.25);padding:12px;border-radius:12px;border:1px solid rgba(255,255,255,.12)"><?= htmlspecialchars(json_encode($result, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE)) ?></pre>
      <?php endif; ?>
    </div>
  </div>

  <div class="col-4">
    <?php require __DIR__ . '/includes/wallet.php'; $bal = wallet_get_balance($u['id']); ?>
    <div class="card">
      <h2>Wallet</h2>
      <div class="notice ok"><b>Balance:</b> ₹<?= number_format($bal,2) ?></div>
      <div class="row">
        <a class="btn primary" href="/wallet_recharge.php">Recharge</a>
        <a class="btn" href="/wallet_ledger.php">Ledger</a>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
