<?php
require_once __DIR__ . '/includes/session.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

$err = '';
$ok = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $name = trim($_POST['name'] ?? '');
  $email = strtolower(trim($_POST['email'] ?? ''));
  $phone = trim($_POST['phone'] ?? '');
  $pass = $_POST['password'] ?? '';

  if (!$name || !$email || !$phone || strlen($pass) < 6) {
    $err = 'Please fill all fields (password min 6).';
  } else {
    try {
      $pdo = db();
      $hash = password_hash($pass, PASSWORD_BCRYPT);
      $stmt = $pdo->prepare("INSERT INTO users(name,email,phone,password_hash,role,status,created_at,updated_at) VALUES(?,?,?,?, 'user',1,NOW(),NOW())");
      $stmt->execute([$name,$email,$phone,$hash]);
      $uid = (int)$pdo->lastInsertId();
      $pdo->prepare("INSERT INTO wallets(user_id,balance,created_at,updated_at) VALUES(?,?,NOW(),NOW())")->execute([$uid,0]);
      $ok = 'Account created. Please login.';
    } catch(Exception $e){
      $err = 'Error: ' . $e->getMessage();
    }
  }
}

require __DIR__ . '/_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-4"></div>
  <div class="col-4">
    <div class="card">
      <h2>Create Account</h2>
      <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>

      <form method="post">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <label>Full Name</label>
        <input name="name" required>
        <label>Email</label>
        <input type="email" name="email" required>
        <label>Phone</label>
        <input name="phone" required>
        <label>Password</label>
        <input type="password" name="password" minlength="6" required>
        <div class="row" style="margin-top:12px">
          <button class="btn primary" type="submit">Create</button>
          <a class="btn" href="/login.php">Login</a>
        </div>
      </form>
    </div>
  </div>
  <div class="col-4"></div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
