<?php
require_once __DIR__ . '/includes/session.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

$err='';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = strtolower(trim($_POST['email'] ?? ''));
  $pass = $_POST['password'] ?? '';
  try {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND status=1 LIMIT 1");
    $stmt->execute([$email]);
    $u = $stmt->fetch();
    if (!$u || !password_verify($pass, $u['password_hash'])) {
      $err = 'Invalid credentials';
    } else {
      login_user($u);
      header('Location: /dashboard.php');
      exit;
    }
  } catch(Exception $e){
    $err = 'Error: ' . $e->getMessage();
  }
}

require __DIR__ . '/_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-4"></div>
  <div class="col-4">
    <div class="card">
      <h2>Login</h2>
      <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <form method="post">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <label>Email</label>
        <input type="email" name="email" required>
        <label>Password</label>
        <input type="password" name="password" required>
        <div class="row" style="margin-top:12px">
          <button class="btn primary" type="submit">Login</button>
          <a class="btn" href="/register.php">Create Account</a>
        </div>
      </form>
      <div class="small" style="margin-top:10px">Admin access is under <b>/admin/</b> (role=admin).</div>
    </div>
  </div>
  <div class="col-4"></div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
