<?php
// Simple installer: uploads config + imports SQL manually via phpMyAdmin is recommended.
// This file only helps generate config.php quickly.
require_once __DIR__ . '/includes/session.php';
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $host = trim($_POST['db_host'] ?? 'localhost');
  $name = trim($_POST['db_name'] ?? '');
  $user = trim($_POST['db_user'] ?? '');
  $pass = trim($_POST['db_pass'] ?? '');
  if(!$name || !$user){
    $err='DB name and user required';
  } else {
    $key = bin2hex(random_bytes(16));
    $config = "<?php\nreturn [\n"
      ."  'app_name' => 'HemaVishwas12 Portal',\n"
      ."  'base_url' => '',\n"
      ."  'db' => [\n"
      ."    'host' => '".addslashes($host)."',\n"
      ."    'name' => '".addslashes($name)."',\n"
      ."    'user' => '".addslashes($user)."',\n"
      ."    'pass' => '".addslashes($pass)."',\n"
      ."    'charset' => 'utf8mb4',\n"
      ."  ],\n"
      ."  'app_key' => '".$key."',\n"
      ."  'payment' => [\n"
      ."    'provider' => 'manual',\n"
      ."    'webhook_secret' => '',\n"
      ."  ],\n"
      ."];\n";
    @mkdir(__DIR__.'/config',0775,true);
    file_put_contents(__DIR__.'/config/config.php', $config);
    $ok="config/config.php created. Now import SQL from /sql/schema.sql in phpMyAdmin. Then open /admin/ (login using seeded admin).";
  }
}
?>
<!doctype html>
<html lang="en"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Install</title><link rel="stylesheet" href="/assets/css/style.css"></head>
<body><div class="wrap">
<div class="card" style="margin-top:14px">
<h2>Install Portal</h2>
<?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
<?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>
<form method="post">
  <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
  <label>DB Host</label><input name="db_host" value="localhost">
  <label>DB Name</label><input name="db_name" required>
  <label>DB User</label><input name="db_user" required>
  <label>DB Password</label><input name="db_pass" type="password">
  <div class="row" style="margin-top:12px"><button class="btn primary" type="submit">Create Config</button></div>
</form>
<p class="small" style="margin-top:10px">After config created, import SQL and then remove install.php for security.</p>
</div></div></body></html>
