<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/session.php';

function current_user() {
  start_session();
  return $_SESSION['user'] ?? null;
}
function require_login() {
  if (!current_user()) {
    header('Location: /login.php');
    exit;
  }
}
function require_admin() {
  $u = current_user();
  if (!$u || ($u['role'] ?? '') !== 'admin') {
    http_response_code(403);
    exit('Forbidden');
  }
}
function login_user($userRow) {
  start_session();
  $_SESSION['user'] = [
    'id' => (int)$userRow['id'],
    'name' => $userRow['name'],
    'email' => $userRow['email'],
    'phone' => $userRow['phone'],
    'role' => $userRow['role'],
  ];
}
function logout_user() {
  start_session();
  session_destroy();
}
