<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/wallet.php';
require_once __DIR__ . '/includes/db.php';
require_login();
$u = current_user();

$pdo = db();
$bal = wallet_get_balance($u['id']);

$stmt = $pdo->prepare("SELECT * FROM services WHERE status=1 ORDER BY sort_order ASC, id DESC");
$stmt->execute();
$services = $stmt->fetchAll();

// Recent requests
$r = $pdo->prepare("SELECT sr.*, s.name AS service_name FROM service_requests sr JOIN services s ON s.id=sr.service_id
                    WHERE sr.user_id=? ORDER BY sr.id DESC LIMIT 10");
$r->execute([$u['id']]);
$recent = $r->fetchAll();

require __DIR__ . '/_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-8">
    <div class="card">
      <h2>Services</h2>
      <div class="service-grid">
        <?php foreach($services as $s): ?>
          <a class="service-tile" href="/service.php?code=<?= urlencode($s['code']) ?>">
            <b><?= htmlspecialchars($s['name']) ?></b>
            <div class="small">Price: ₹<?= number_format((float)$s['price'],2) ?> / hit</div>
          </a>
        <?php endforeach; ?>
        <?php if(!$services): ?>
          <div class="notice">No services enabled. Ask admin to add services.</div>
        <?php endif; ?>
      </div>
    </div>

    <div class="card" style="margin-top:12px">
      <h2>Recent Activity</h2>
      <table class="table">
        <thead><tr><th>#</th><th>Service</th><th>Status</th><th>Cost</th><th>Date</th></tr></thead>
        <tbody>
        <?php foreach($recent as $row): ?>
          <tr>
            <td><?= (int)$row['id'] ?></td>
            <td><?= htmlspecialchars($row['service_name']) ?></td>
            <td><span class="badge <?= $row['status']=='SUCCESS'?'on':'off' ?>"><?= htmlspecialchars($row['status']) ?></span></td>
            <td>₹<?= number_format((float)$row['cost'],2) ?></td>
            <td><?= htmlspecialchars($row['created_at']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$recent): ?><tr><td colspan="5" class="small">No activity yet.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="col-4">
    <div class="card">
      <h2>Wallet</h2>
      <div class="notice ok"><b>Balance:</b> ₹<?= number_format($bal,2) ?></div>
      <div class="row">
        <a class="btn primary" href="/wallet_recharge.php">Recharge</a>
        <a class="btn" href="/wallet_ledger.php">Ledger</a>
      </div>
      <div class="small" style="margin-top:10px">
        Recharge page is <b>manual demo</b> by default. You can connect payment gateway later.
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
