<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/wallet.php';
require_admin();
$pdo = db();
$err=''; $ok='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $action = $_POST['action'] ?? '';
  $uid = (int)($_POST['user_id'] ?? 0);

  try{
    if($action==='toggle' && $uid){
      $pdo->prepare("UPDATE users SET status = IF(status=1,0,1) WHERE id=?")->execute([$uid]);
      $ok='Updated.';
    }
    if($action==='credit' && $uid){
      $amt = (float)($_POST['amount'] ?? 0);
      wallet_credit($uid, $amt, 'ADMIN_CREDIT', 'admin', 0);
      $ok='Wallet credited.';
    }
  } catch(Exception $e){
    $err='Error: '.$e->getMessage();
  }
}

$rows = $pdo->query("SELECT id,name,email,phone,role,status,created_at FROM users ORDER BY id DESC LIMIT 300")->fetchAll();

require __DIR__ . '/../_layout_top.php';
?>
<div class="card" style="margin-top:14px">
  <h2>Users</h2>
  <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
  <?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>

  <table class="table">
    <thead><tr><th>#</th><th>Name</th><th>Email</th><th>Phone</th><th>Role</th><th>Status</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= htmlspecialchars($r['name']) ?></td>
        <td><?= htmlspecialchars($r['email']) ?></td>
        <td><?= htmlspecialchars($r['phone']) ?></td>
        <td><?= htmlspecialchars($r['role']) ?></td>
        <td><span class="badge <?= $r['status']==1?'on':'off' ?>"><?= $r['status']==1?'ACTIVE':'BLOCKED' ?></span></td>
        <td>
          <form method="post" style="display:inline">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
            <input type="hidden" name="action" value="toggle">
            <input type="hidden" name="user_id" value="<?= (int)$r['id'] ?>">
            <button class="btn" type="submit"><?= $r['status']==1?'Block':'Unblock' ?></button>
          </form>

          <form method="post" style="display:inline; margin-left:6px">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
            <input type="hidden" name="action" value="credit">
            <input type="hidden" name="user_id" value="<?= (int)$r['id'] ?>">
            <input name="amount" type="number" step="0.01" min="1" placeholder="₹" style="width:90px; display:inline-block">
            <button class="btn primary" type="submit">Credit</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__ . '/../_layout_bottom.php'; ?>
