<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/db.php';
require_admin();
$pdo = db();
$err=''; $ok='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $action = $_POST['action'] ?? '';
  try{
    if($action==='add'){
      $name = trim($_POST['name'] ?? '');
      $code = trim($_POST['code'] ?? '');
      $price = (float)($_POST['price'] ?? 0);
      $endpoint = trim($_POST['endpoint_url'] ?? '');
      $method = strtoupper(trim($_POST['http_method'] ?? 'POST'));
      $api_key = trim($_POST['api_key'] ?? '');
      $sort = (int)($_POST['sort_order'] ?? 0);
      if(!$name || !$code || $price<=0) throw new Exception("Name/code/price required");
      $pdo->prepare("INSERT INTO services(name,code,price,status,endpoint_url,http_method,api_key,sort_order,created_at,updated_at) 
                     VALUES(?,?,?,1,?,?,?,?,NOW(),NOW())")
          ->execute([$name,$code,$price,$endpoint,$method,$api_key,$sort]);
      $ok='Service added.';
    }
    if($action==='toggle'){
      $sid = (int)($_POST['service_id'] ?? 0);
      $pdo->prepare("UPDATE services SET status = IF(status=1,0,1) WHERE id=?")->execute([$sid]);
      $ok='Updated.';
    }
    if($action==='delete'){
      $sid = (int)($_POST['service_id'] ?? 0);
      $pdo->prepare("DELETE FROM services WHERE id=?")->execute([$sid]);
      $ok='Deleted.';
    }
  } catch(Exception $e){ $err='Error: '.$e->getMessage(); }
}

$rows = $pdo->query("SELECT * FROM services ORDER BY sort_order ASC, id DESC")->fetchAll();

require __DIR__ . '/../_layout_top.php';
?>
<div class="grid" style="margin-top:14px">
  <div class="col-4">
    <div class="card">
      <h2>Add Service</h2>
      <?php if($err): ?><div class="notice err"><?= htmlspecialchars($err) ?></div><?php endif; ?>
      <?php if($ok): ?><div class="notice ok"><?= htmlspecialchars($ok) ?></div><?php endif; ?>
      <form method="post">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <input type="hidden" name="action" value="add">
        <label>Name</label><input name="name" required>
        <label>Code (unique)</label><input name="code" placeholder="e.g. ifsc_info" required>
        <label>Price (₹ per hit)</label><input name="price" type="number" step="0.01" min="0.01" required>
        <label>Endpoint URL (optional)</label><input name="endpoint_url" placeholder="https://api.example.com/lookup">
        <label>HTTP Method</label>
        <select name="http_method"><option>POST</option><option>GET</option><option>PUT</option></select>
        <label>API Key (Bearer) optional</label><input name="api_key" placeholder="leave blank if none">
        <label>Sort Order</label><input name="sort_order" type="number" value="0">
        <div class="row" style="margin-top:12px">
          <button class="btn primary" type="submit">Add</button>
        </div>
      </form>
      <div class="small" style="margin-top:10px">API call is JSON by default. For custom headers/body, extend service.php.</div>
    </div>
  </div>

  <div class="col-8">
    <div class="card">
      <h2>Services</h2>
      <table class="table">
        <thead><tr><th>#</th><th>Name</th><th>Code</th><th>Price</th><th>Status</th><th>Endpoint</th><th>Actions</th></tr></thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['name']) ?></td>
            <td><?= htmlspecialchars($r['code']) ?></td>
            <td>₹<?= number_format((float)$r['price'],2) ?></td>
            <td><span class="badge <?= $r['status']==1?'on':'off' ?>"><?= $r['status']==1?'ON':'OFF' ?></span></td>
            <td class="small"><?= htmlspecialchars($r['endpoint_url'] ?: '-') ?></td>
            <td>
              <form method="post" style="display:inline">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                <input type="hidden" name="action" value="toggle">
                <input type="hidden" name="service_id" value="<?= (int)$r['id'] ?>">
                <button class="btn" type="submit"><?= $r['status']==1?'Disable':'Enable' ?></button>
              </form>
              <form method="post" style="display:inline; margin-left:6px" onsubmit="return confirm('Delete service?');">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="service_id" value="<?= (int)$r['id'] ?>">
                <button class="btn danger" type="submit">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="7" class="small">No services.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../_layout_bottom.php'; ?>
