<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_admin();
$pdo = db();
$rows = $pdo->query("SELECT sr.*, u.email, s.name AS service_name
                     FROM service_requests sr
                     JOIN users u ON u.id=sr.user_id
                     JOIN services s ON s.id=sr.service_id
                     ORDER BY sr.id DESC LIMIT 500")->fetchAll();
require __DIR__ . '/../_layout_top.php';
?>
<div class="card" style="margin-top:14px">
  <h2>Service Requests</h2>
  <table class="table">
    <thead><tr><th>#</th><th>User</th><th>Service</th><th>Status</th><th>Cost</th><th>Input</th><th>Date</th></tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= htmlspecialchars($r['email']) ?></td>
        <td><?= htmlspecialchars($r['service_name']) ?></td>
        <td><span class="badge <?= $r['status']=='SUCCESS'?'on':'off' ?>"><?= htmlspecialchars($r['status']) ?></span></td>
        <td>₹<?= number_format((float)$r['cost'],2) ?></td>
        <td class="small"><?= htmlspecialchars($r['input_json']) ?></td>
        <td><?= htmlspecialchars($r['created_at']) ?></td>
      </tr>
    <?php endforeach; ?>
    <?php if(!$rows): ?><tr><td colspan="7" class="small">No requests.</td></tr><?php endif; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__ . '/../_layout_bottom.php'; ?>
