<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_admin();
$pdo = db();
$rows = $pdo->query("SELECT p.*, u.email FROM payments p JOIN users u ON u.id=p.user_id ORDER BY p.id DESC LIMIT 500")->fetchAll();
require __DIR__ . '/../_layout_top.php';
?>
<div class="card" style="margin-top:14px">
  <h2>Payments</h2>
  <table class="table">
    <thead><tr><th>#</th><th>User</th><th>Gateway</th><th>Order</th><th>Txn</th><th>Amount</th><th>Status</th><th>Date</th></tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= htmlspecialchars($r['email']) ?></td>
        <td><?= htmlspecialchars($r['gateway']) ?></td>
        <td class="small"><?= htmlspecialchars($r['order_id']) ?></td>
        <td class="small"><?= htmlspecialchars($r['txn_id']) ?></td>
        <td>₹<?= number_format((float)$r['amount'],2) ?></td>
        <td><?= htmlspecialchars($r['status']) ?></td>
        <td><?= htmlspecialchars($r['created_at']) ?></td>
      </tr>
    <?php endforeach; ?>
    <?php if(!$rows): ?><tr><td colspan="8" class="small">No payments.</td></tr><?php endif; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__ . '/../_layout_bottom.php'; ?>
