<?php
$cfg = require __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/session.php';
require_once __DIR__ . '/includes/auth.php';
$u = current_user();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($cfg['app_name']) ?></title>
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="wrap">
  <div class="nav">
    <a class="brand" href="/">
      <span class="logo"></span>
      <span><?= htmlspecialchars($cfg['app_name']) ?></span>
    </a>
    <div class="row">
      <?php if($u): ?>
        <span class="badge"><?= htmlspecialchars($u['name']) ?></span>
        <?php if(($u['role'] ?? '') === 'admin'): ?>
          <a class="btn" href="/admin/">Admin</a>
        <?php endif; ?>
        <a class="btn" href="/dashboard.php">Dashboard</a>
        <a class="btn danger" href="/logout.php">Logout</a>
      <?php else: ?>
        <a class="btn" href="/login.php">Login</a>
        <a class="btn primary" href="/register.php">Create Account</a>
      <?php endif; ?>
    </div>
  </div>
